/* ============ */
/* setpoker.c	*/
/* ============ */
#include <defcodes.h>
#include <miscdefs.h>
#include <pokrdefs.h>
#include <math.h>

#define	ACT(X)	#X

#define	NEED_CARDS_PER_HAND(LO, HI) \
	"Enter Number of Cards Per Hand ["ACT(LO)"-"ACT(HI)"]: "
#define	NEED_NUMBER_UNIQUE_CARDS(LO, HI) \
	"Enter Number of Unique Cards in Random Deck ["\
		ACT(LO)"-"ACT(HI)"]: "
#define	NEED_MIN_CELL_EXPECT(LO, HI) \
	"Enter Minimum Cell Expectation ["ACT(LO)"-"ACT(HI)"]: "

#define	SHOW_INT_VALUE_USED(Entered, Used)\
	printf("\tTest Value Used: %d%s\n", Used,\
	(Entered == Used) ? "" : " (Clamped)")

static	double	PokerProbs[MAX_CARDS];
/* ==================================================================== */
/* SetPokerControls - Puts Poker-Test controls in PokerData structure	*/
/* ==================================================================== */
void
SetPokerControls(POKER_DATA_STRU * PokerData)
{
    int     j, NewlineCh;
    int     UserIntEntry;
    long    UserLongEntry;

    NewlineCh = _isatty(_fileno(stdin)) ? '\r' : '\n';

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    /* -------------------------------------- */
    /* Request Number of Cards Per Hand [4-8] */
    /* -------------------------------------- */
    GetInt(NEED_CARDS_PER_HAND(MIN_CARDS, MAX_CARDS),
	&UserIntEntry);
    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    printf("\n\tNumber Entered:  %d", UserIntEntry);
    printf(" (Cards Per Hand)\n");
    /* ------------------ */
    /* Clamp CardsPerHand */
    /* ------------------ */
    PokerData->CardsPerHand =
	__min(MAX_CARDS, __max(MIN_CARDS, UserIntEntry));

    SHOW_INT_VALUE_USED(UserIntEntry, PokerData->CardsPerHand);

    /* --------------------------------------------- */
    /* Request Number of Unique Cards in Random Deck */
    /* --------------------------------------------- */
    GetInt(NEED_NUMBER_UNIQUE_CARDS(MIN_DECK_SIZE, MAX_DECK_SIZE),
	&UserIntEntry);

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    printf("\n\tNumber Entered:  %d", UserIntEntry);
    printf(" (Number Unique Cards in Random Deck\n");
    /* -------------- */
    /* Clamp DataSize */
    /* -------------- */
    PokerData->DataSize =
	__min(MAX_DECK_SIZE, __max(MIN_DECK_SIZE, UserIntEntry));

    SHOW_INT_VALUE_USED(UserIntEntry, PokerData->DataSize);

    /* -------------------------------- */
    /* Request Minimum Cell Expectation	*/
    /* -------------------------------- */
    GetInt(NEED_MIN_CELL_EXPECT(MIN_CELL_XPCT, MAX_CELL_XPCT),
	&UserIntEntry);

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    printf("\n\tNumber Entered:  %d", UserIntEntry);
    printf(" (Cell Expectation)\n");

    /* ---------------- */
    /* Clamp CellExpect */
    /* ---------------- */
    PokerData->UserCellExpect =
	__min(MAX_CELL_XPCT, __max(MIN_CELL_XPCT, UserIntEntry));

    SHOW_INT_VALUE_USED(UserIntEntry, PokerData->UserCellExpect);

    /* -------------------------------------------------- */
    /* Calculate Cell Expectations Based on Probabilities */
    /* -------------------------------------------------- */
    CalcPokerProbs(PokerData->CardsPerHand, PokerData->DataSize,
	PokerProbs);

    PokerData->IdealNumHands = (ULONG)
	(((double)MIN_CELL_XPCT + PokerProbs[0])/PokerProbs[0]);

    PokerData->UserNumHands = (ULONG)
	((PokerData->UserCellExpect + PokerProbs[0])/PokerProbs[0]);
    {
	char	Prompt[64];
	int	SpareCards;

	SpareCards = PokerData->CardsPerHand - MIN_CARDS;
printf("# Spare Cards = %d, PokerProbs = %.15g\n",
SpareCards, PokerProbs[SpareCards]);
	sprintf(Prompt,
	    "How Many Hands Per Run Should Be Dealt? [%.f ...]: ",
	    floor(0.5 + PokerData->UserCellExpect/PokerProbs[SpareCards]));

	GetLong(Prompt, &UserLongEntry);
    }

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    printf("\n\tNumber Entered:  %ld", UserLongEntry);
    printf(" (Number of Hands to Be Dealt)\n");
    printf("\tTest Value Used: %ld\n", UserLongEntry);

    PokerData->NumHands = UserLongEntry;

    /* ------------------------------- */
    /* Calculate Category Expectations */
    /* ------------------------------- */
    for (j = 0; j < PokerData->CardsPerHand; ++j)
    {
	PokerData->CellExpect[j] = PokerProbs[j] * PokerData->NumHands;
	P(printf("PokerProbs[%2d] = %.11e, ", j, PokerProbs[j]));
	P(printf("CellExpect[%2d] = %.11e\n", j, PokerData->CellExpect[j]));
    }

    PokerData->NotEnough = 0;
    /* -------------------------------------------------- */
    /* Lump lower-valued categories into next higher ones */
    /* -------------------------------------------------- */
    for (j = 0; j < PokerData->CardsPerHand-1; ++j)
    {
	/* if (PokerData->CellExpect[j] < 1.0) */
	if (PokerData->CellExpect[j] < (double)PokerData->UserCellExpect)
	{
	    ++PokerData->NotEnough;
	    PokerData->CellExpect[j+1] += PokerData->CellExpect[j];
	    PokerData->CellExpect[j]    = 0;
	}
    }
    P(printf("NotEnough = %d\n", PokerData->NotEnough));
    PokerData->CallStatusOK = (PokerData->NotEnough == 0);
}
